function [mse_best_test,mse_best_train,lambda_best] = give_me_best_mse(kernel_train,kernel_test,y_train,y_test)
lambda = [0,0.01,0.1,0.2,0.3,0.4,0.5,0.6,0.7,0.8,0.8,1,2,3,4,5,6,7,8,10,100];
kfold = length(kernel_train);
n = length(lambda);
mse_best_test = 100000;
mse_best_train = 100000;
lambda_best = 0;
for i = 1:n
    mse_current_test = 0;
    mse_current_train = 0;
    for k = 1:kfold
        b = pinv(kernel_train{k} + lambda(i)*eye(size(kernel_train{k})))*y_train{k};
        y_hat_test = kernel_test{k}*b;
        y_hat_train = kernel_train{k}*b;
        mse_current_test = mse_current_test + mean((y_test{k} - y_hat_test).^2)/kfold;
        mse_current_train = mse_current_train + mean((y_train{k} - y_hat_train).^2)/kfold;
    end
    if (mse_current_test < mse_best_test) && (mse_current_train <= mse_best_test)
        lambda_best = lambda(i);
        mse_best_test = mse_current_test;
        mse_best_train = mse_current_train;
    end
        
end
end

